pro stat_regr_out,   ineq,n_ineq, varname, result, R, Rmul, ssigma, betta, T_emp, T_prob, const, DF,   F_emp , n_x
; standard output of results
; output format: format1='(a'+strtrim(max(strlen(varname)),2)+',e11.2,f6.1,2e11.2,f7.3,f7.1)'
print,' Var       m           R %       S(m)          Beta       Temp  Tprob'
for t=0,n_ineq-1 do print, varname(ineq(t)), result(t), R(t)^2*100., ssigma(t), betta(t),  T_emp(t),T_prob(t),$
	format ='(a'+strtrim(max(strlen(varname)),2)+',e11.2,f6.1,2e11.2,f7.3,f7.1)'

if F_emp ne -999.9 then begin
;	print,'       C             R %       F_emp
	print
	print,' Const ',const,' R ',Rmul^2*100.,'%  F_emp ',F_emp,format='(a7,f12.3,a4,f5.1,a9,f9.3)'
	F_prob=F_PDF(F_emp,n_ineq,DF)
	print,' F_prob ',F_prob*100,'  J ',n_ineq,' DF ' ,DF, '  n ', n_x , format='(a7,f7.1,3(a4,i4))'
	print
endif
end
;____________________________________________

pro my_stepwise,x,y,ineq, result,const,Rmul,R,Yfit,id, org_result , silent=silent,file_out=file_out, var_names=vn, z=z, initial = initial
; IDL 5.1 12.9.2000
; Axel Thomas, Institute of Geography, Johannes Gutenberg University, Mainz, Germany
; a.thomas@geo.uni-mainz.de
;
; ============================DISCLAIMER================================
; You may use, copy, modify, merge, distribute, alter, reproduce and/or
; create derivative works of this code for your own internal use. 
;
; THIS CODE IS PROVIDED "AS-IS" WITHOUT WARRANTY OF ANY KIND, EITHER
; EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
; WITH RESPECT TO THE CODE.
;
; for scientific use only!!
; all rights copyright A.Thomas 2000, not for for commercial use
; cite as: my_stepwise, IDL code for multople stepwise regression by A.Thomas, Institute of Geography, Mainz University, Germany
; ======================================================================
;
; calculates multiple stepwise linear regression
; variable selection by T-Test of regression coefficients
;
; X				m x n fltarr of  independant variables
; Y				n vector of  dependant variables
; id				optional string for  output
; org_result			array of initial results (option /initial)
; keywords
; silent			no screen output
; file_out			pathname for output file
; var_names 			array of variable names
; z				standardisation of variables
; initial			output of initial regressions
;_______________________________________________

x_in=x																																				; Umsetzen der Unabhngigen var.
x_size=size(x_in)
n_ineq = x_size(1)																														; Anzahl der Var i.d.Gl.
n_x =  x_size(2)																															; Anzahl Flle

if n_x gt 3 then begin
	T_in = 95.																																	; Einschluniveau fr T-Test
	T_out = 90.																																	; Ausschluniveau fr T-Test
endif else begin
	T_in = 90.																																	; verringerte Anforderungen bei nur 3 Fllen
	T_out = 88.
endelse

if keyword_set(z) then begin
	z_x = x
	for ii = 0,n_ineq-1 do begin
		my_standardize,x(ii,*),zx
		z_x(ii,*) = zx
	endfor
	x=z_x
endif
w=replicate(1.,n_x)																														; Gewichte: keine Gewichtung
y_stddev=stddev(y)
NC=Size(vn)																																	; umstndlich? bernommen aus stepwise...
	if(NC(1) NE 0 ) THEN BEGIN        ;
	varname=vn
	if(NC(1) LT n_ineq) THEN BEGIN
    	print,'stepwise-missing variable names'
    	I=indgen(n_ineq)
    	varname=[varname,'Var'+strtrim(I(NC(1):n_ineq-1),2)]
    ENDIF
ENDIF ELSE varname='Var'+ strtrim(indgen(n_ineq),2)
;print,varname
name_len=max(strlen(varname))

;*****************   1. test of all variables
x_in=x
ineq = indgen(n_ineq)
betta=dblarr(n_ineq)

ssigma =fltarr(n_ineq) &  F_emp = ssigma &  R=ssigma   & result = ssigma & c = ssigma
for i = 0,n_ineq-1 do begin
	x_in=reform(x(i,*),1,n_x)
	m = REGRESS(x_in,y, w , Yfit, C1, s1, F1, R1,  /RELATIVE_WEIGHT)						; first regression with all variables
	result(i) = m
	c(i) = C1
	ssigma(i) = s1
	R(i) = R1
	betta(i) = result(i) * stddev(x_in) / y_stddev
endfor
const = -999.9														; set "no values" for the entire equation
F_emp = -999.9
Rmul = -999.9
;for t=0,n_ineq-1 do betta(t) = result(t)*stddev(x_in(t,*))/y_stddev

T_prob=make_array(n_ineq,/float,val=0.)  & T_emp = T_prob

DF=n_x-1-1														; only one independant variable
if DF lt 1 then DF = 1
T_tab=	T_CVF(0.025,DF )												; t-test
nan = where(FINITE(ssigma) ge 1,n_nan)											; tests if Sigma is a real value

if n_nan gt 0 then T_emp(nan) = abs(result(nan) / ssigma(nan))								; tests if t_test is possible 

for t=0,n_ineq-2 do T_prob(t) = T_PDF(T_emp(t), DF)*100									; empirical t-value
sort_var=reverse(sort(R^2))  												; sort variables by declared variance


if not keyword_set(silent) then begin
	print,'Initial equation: all variables in the equation'								; first step: all variables in the equation
	stat_regr_out,  ineq, n_ineq, varname(sort_var), result(sort_var), R(sort_var), Rmul, ssigma(sort_var), betta(sort_var), T_emp(sort_var), T_prob(sort_var), const, DF, F_emp, n_x
endif
if  keyword_set(initial) then begin
	org_result = make_array(5,n_ineq,/double)
	for t=0,n_ineq-1 do begin
		org_result(0,t) = ineq(sort_var(t))
		org_result(1,t) =result(sort_var(t))
		org_result(2,t) =c(sort_var(t))
		org_result(3,t) =R(sort_var(t))^2*100
		org_result(4,t) = T_prob(sort_var(t))
	endfor
endif
;__________________ significance of equation with first variable and new selection of first variable if necessary
DF=n_x-n_ineq-1														; degrees of freedom: number of cases - number of variables in the equ. -1
if DF lt 1 then DF = 1
sig=where(T_prob(sort_var) ge  T_in, n_T_test)										; t-test of significant var. 

if (sig(0) ne -1 ) then begin												; if at least 1 significant variable is found proceed

if not keyword_set(silent) then print,'ranking order in the selection: ',varname(sort_var(sig)) 
; All variable initially NOT in the equ.
		ineq = replicate(-1,1)
		n_ineq= 0
		not_ineq =  sort_var(sig)
		n_not_ineq = n_elements(not_ineq)									; number of variables not in the equ.

for i=0,n_not_ineq-1 do begin												; test all significant variables, independant of their variance

  	ineq_alt = ineq
	n_ineq = n_ineq +1
	ineq=intarr(n_ineq)												; increase number of variables in the equ.
	if (n_ineq ne 1) then  ineq(0:n_ineq-2) = ineq_alt								; add next variable
	ineq(n_ineq-1) = not_ineq(i)

	;___________________ regression with all momentarily selected variables
	x_in=replicate(0,n_ineq,n_x)											; x_in always as array (even if n_ineq = 1)
	x_in = x(ineq,*)												; load variable in the equ.
	if not keyword_set(silent) then print,n_ineq,' variable(s) in the equation: ',varname(ineq)
	result = REGRESS(x_in,y, w , Yfit, const, ssigma, F_emp, R, Rmul, Chisq, Status, /RELATIVE_WEIGHT)		; calculates regression
	betta=dblarr(n_ineq)
	for t=0,n_ineq-1 do betta(t) = result(t)*stddev(x_in(t,*)) / y_stddev
	DF=n_x-n_ineq-1
	if DF lt 1 then DF = 1
	T_prob=fltarr(n_ineq)
	T_tab=	T_CVF(0.025, DF)											; t-test
	nan = where(FINITE(ssigma) ge 1,n_nan)										; tests if t_test is possible
	if n_nan gt 0 then T_emp(nan) = abs(result(nan) / ssigma(nan))					; 
;	T_emp = abs(result / ssigma)

	for t=0,n_ineq-1 do T_prob(t) = T_PDF(T_emp(t), DF) * 100
	if not keyword_set(silent) then stat_regr_out,  ineq, n_ineq, varname, result, R, Rmul, ssigma, betta, T_emp, T_prob, const, DF, F_emp, n_x

	ok_T=where (T_prob ge T_out and R^2 ge 0.001,n_T_test)								; t-test significant AND variance > 0 ?
	if n_T_test gt 0 then begin
		ineq =  ineq(ok_T)				& 	if not keyword_set(silent) then  print,'remains: ',varname(ineq)
	endif else begin
		ineq = replicate(-1,1)
		n_ineq= 0					& 	if not keyword_set(silent) then  print,'no variable remains'							; 
	endelse

endfor
;________________________ 	list of results
if n_ineq eq 0 then begin												; if no equ. with > 1 significant variable
	n_ineq = 1
	ineq=sort_var(sig(0))												;  selects first significant variable with highest variance
endif
;if n_ineq gt 0 then begin				; not really necessary as at least one variable available if a significant variable is in the initial equ.
	x_in=replicate(0,n_ineq,n_x)
	x_in = x(ineq,*)				; loading variables
	result = REGRESS(x_in,y, w , Yfit, const, ssigma, F_emp, R, Rmul, Chisq, Status, /RELATIVE_WEIGHT)		;  regression with selected variables
	betta=dblarr(n_ineq)
	for t=0,n_ineq-1 do betta(t) = result(t)*stddev(x_in(t,*)) / y_stddev
	DF=n_x-n_ineq-1
	if DF lt 1 then DF = 1
	T_tab=	T_CVF(0.025, DF)											; t-test
	T_emp = abs(result / ssigma)
	T_prob=fltarr(n_ineq)
	for t=0,n_ineq-1 do T_prob(t) = T_PDF(T_emp(t), DF) * 100
	print,'Final Statistics'
	print,'variables in the equation: ',varname(ineq)
	stat_regr_out,  ineq, n_ineq, varname, result, R, Rmul, ssigma, betta, T_emp, T_prob, const, DF, F_emp, n_x
	if keyword_set(file_out) then begin
		openw,lun_out,file_out,/get_lun
		if n_params() eq 9 then printf,lun_out, id
		printf,lun_out,'variables in the equation: ', varname(ineq)
		printf,lun_out,'Var     m           R %       S(m)         Beta         Temp  Ttab'
		for t=0,n_ineq-1 do printf,lun_out, varname(ineq(t)),result(t),R(t)^2*100.,ssigma(t), betta(t),T_tab,T_prob(t), format='(a'+strtrim(max(strlen(varname)),2)+',e11.2,f6.1,2e11.2,f7.3,f7.1)'
		printf, lun_out,'     C           R %     F_emp
		printf,lun_out,const,Rmul^2*100.,F_emp,format='(f9.4,f6.1,f7.3)'
		printf,lun_out, 'F_prob J  DF  n, ',F_prob*100, n_ineq,DF,n_x,format='(a15,f7.1,3i4)'
	free_lun,lun_out
	endif
;endif else begin
;	print,'no variables in the equation'
;	result =-999.9
;	const =-999.9
;	Rmul =-999.9
;	R =-999.9
;	Yfit =-999.9
;	ineq = replicate(-1,1)
;	n_ineq=0
;	if keyword_set(file_out) then begin
;		printf,lun_out,'no variables in the equation'
;		free_lun,lun_out
;	endif
;endelse
endif else begin													; no variable sigificant
	print,'no variables in the equation'										; no variables in the equ.
	result =-999.9
	const =-999.9
	Rmul =-999.9
	R =-999.9
	Yfit =-999.9
	ineq = replicate(-1,1)
	n_ineq=0
	if keyword_set(file_out) then begin
		openw,lun_out,file_out,/get_lun
		printf,lun_out,'no variables in the equation'
		free_lun,lun_out
	endif
endelse
end
;_________________________________________________________________________________________
